local t = LoadFallbackB();
local Players = GAMESTATE:GetEnabledPlayers()
local tContainer = MetroQuad.Global.MiscOptions.TimerCountDownContainer
if tContainer < 1 then tContainer = 4 else MetroQuad.Global.MiscOptions.TimerCountDownContainer = 0 end
t[#t+1] = LoadActor("../_MenuTimer",tContainer)..{InitCommand=cmd(xy,CenterX(),Top()+14;)}

-- Played RateMods
local ratemod = MetroQuad.Global.MiscOptions.RateModUsed
table.insert(MetroQuad.Global.PlayedRateMods,1,tostring(ratemod))

for pn in ivalues(Players) do
	t[#t+1] = Def.ActorFrame{
		Name=ToEnumShortString(pn).." AF Upper",
		OnCommand=function(self)
			if pn == PLAYER_1 then
				self:x(_screen.cx - 155)
			elseif pn == PLAYER_2 then
				self:x(_screen.cx + 155)
			end
		end
	}

	t[#t+1] = Def.ActorFrame{
		Name=ToEnumShortString(pn).." AF Lower",
		OnCommand=function(self)
			if GAMESTATE:GetCurrentStyle():GetStyleType() == "StyleType_OnePlayerTwoSides" then
				self:x(_screen.cx)
			else
				if pn == PLAYER_1 then
					self:x(_screen.cx - 155)
				elseif pn == PLAYER_2 then
					self:x(_screen.cx + 155)
				end
			end
		end,

		-- percentage score
		LoadActor("percentage", pn)..{
			Name="PercentageContainer"..ToEnumShortString(pn),
			InitCommand=function(self)
				self:visible(false)
			end,
			OnCommand=function(self)
				-- Format the Percentage string, removing the % symbol
				local text = self:GetText()
				text = text:gsub("%%", "")
				self:settext(text)
			end
		}
	}
end

for pn in ivalues(PlayerNumber) do
	local MetricsName = "MachineRecord" .. PlayerNumberToString(pn);
	t[#t+1] = LoadActor( THEME:GetPathG(Var "LoadingScreen", "MachineRecord"), pn ) .. {
		InitCommand=function(self) 
			self:player(pn); 
			self:name(MetricsName); 
			ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
		end;
	};
end

for pn in ivalues(PlayerNumber) do
	local MetricsName = "PersonalRecord" .. PlayerNumberToString(pn);
	t[#t+1] = LoadActor( THEME:GetPathG(Var "LoadingScreen", "PersonalRecord"), pn ) .. {
		InitCommand=function(self) 
			self:player(pn); 
			self:name(MetricsName); 
			ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
		end;
	};
end

for pn in ivalues(PlayerNumber) do
	local MetricsName = "StageAward" .. PlayerNumberToString(pn);
	t[#t+1] = LoadActor( THEME:GetPathG(Var "LoadingScreen", "StageAward"), pn ) .. {
		InitCommand=function(self) 
			self:player(pn); 
			self:name(MetricsName); 
			ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
		end;
		BeginCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local tStats = THEME:GetMetric(Var "LoadingScreen", "Summary") and STATSMAN:GetAccumPlayedStageStats() or STATSMAN:GetCurStageStats();
			tStats = tStats:GetPlayerStageStats(pn);
			if tStats:GetStageAward() and not tStats:GetFailed() then
				self:settext( THEME:GetString( "StageAward", ToEnumShortString( tStats:GetStageAward() ) ) );
			else
				self:settext( "" );
			end
		end;
	};
end

for pn in ivalues(PlayerNumber) do
	local MetricsName = "PeakComboAward" .. PlayerNumberToString(pn);
	t[#t+1] = LoadActor( THEME:GetPathG(Var "LoadingScreen", "PeakComboAward"), pn ) .. {
		InitCommand=function(self) 
			self:player(pn); 
			self:name(MetricsName); 
			ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
		end;
		BeginCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local tStats = THEME:GetMetric(Var "LoadingScreen", "Summary") and STATSMAN:GetAccumPlayedStageStats() or STATSMAN:GetCurStageStats();
			tStats = tStats:GetPlayerStageStats(pn);
			if tStats:GetPeakComboAward() then
				self:settext( THEME:GetString( "PeakComboAward", ToEnumShortString( tStats:GetPeakComboAward() ) ) );
			else
				self:settext( "" );
			end
		end;
	};
end

t[#t+1] = CommonNormal()..{
	Text="CHECK YOUR RESULTS!";
	InitCommand=cmd(xy,CenterX(),Top()+28;zoom,0.4;valign,0;shadowlength,1);
};

t[#t+1] = StandardDecorationFromFileOptional("SongInformation","SongInformation") .. {
	BeginCommand=function(self)
		local SongOrCourse;
		if GAMESTATE:GetCurrentSong() then
			SongOrCourse = GAMESTATE:GetCurrentSong();
		elseif GAMESTATE:GetCurrentCourse() then
			SongOrCourse = GAMESTATE:GetCurrentCourse();
		else
			return
		end
		
		if SongOrCourse:HasBanner() then
			self:visible(true);
		else
			self:visible(true);
		end

	end;
	
	SetCommand=function(self)
		local c = self:GetChildren();
		local SongOrCourse;
		if GAMESTATE:GetCurrentSong() then
			SongOrCourse = GAMESTATE:GetCurrentSong();

			c.TextTitle:settext( SongOrCourse:GetDisplayMainTitle() or nil );
			c.TextSubtitle:settext( SongOrCourse:GetDisplaySubTitle() or nil );
			c.TextArtist:settext( SongOrCourse:GetDisplayArtist() or nil );

			if SongOrCourse:GetDisplaySubTitle() == "" then
				c.TextTitle:visible(true);
				c.TextTitle:y(6);
				c.TextSubtitle:visible(false);
				c.TextArtist:visible(true);
				c.TextArtist:y(28);
			else
				c.TextTitle:visible(true);
				c.TextTitle:y(6);
				c.TextSubtitle:visible(true);
				c.TextSubtitle:y(28);
				c.TextArtist:visible(true);
				c.TextArtist:y(46);
			end
		elseif GAMESTATE:GetCurrentCourse() then
			SongOrCourse = GAMESTATE:GetCurrentCourse();
			
			c.TextTitle:settext( SongOrCourse:GetDisplayMainTitle() or nil );
			c.TextSubtitle:settext( SongOrCourse:GetDisplaySubTitle() or nil );
			c.TextArtist:settext( SongOrCourse:GetDisplayArtist() or nil );
		else
			SongOrCourse = nil;
			
			c.TextTitle:settext("");
			c.TextSubtitle:settext("");
			c.TextArtist:settext("");
			
			self:playcommand("Hide")
		end
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	DisplayLanguageChangedMessageCommand=cmd(playcommand,"Set");
};

t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
t[#t+1] = StandardDecorationFromFileOptional("LifeDifficulty","LifeDifficulty");
t[#t+1] = StandardDecorationFromFileOptional("TimingDifficulty","TimingDifficulty");
t[#t+1] = StandardDecorationFromFileOptional("GameType","GameType");

t[#t+1] = Def.ActorFrame {
	Condition=GAMESTATE:HasEarnedExtraStage() and GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2();
	InitCommand=cmd(draworder,105);
	LoadActor( THEME:GetPathS("ScreenEvaluation","try Extra1" ) ) .. {
		Condition=THEME:GetMetric( Var "LoadingScreen","Summary" ) == false;
		OnCommand=cmd(play);
	};
	LoadActor( THEME:GetPathG("ScreenStageInformation","Stage extra1" ) ) .. {
		Condition=THEME:GetMetric( Var "LoadingScreen","Summary" ) == false;
		InitCommand=cmd(Center);
		OnCommand=cmd(diffusealpha,0;zoom,0.85;bounceend,1;zoom,1;diffusealpha,1;sleep,0;glow,Color("White");decelerate,1;glow,Color("Invisible");smooth,0.35;zoom,0.25;y,SCREEN_BOTTOM-72);
	};
};

--t[#t+1] = LoadActor("TabsNumber") .. { InitCommand=cmd(y,4); };
t[#t+1] = LoadActor("BPM")
t[#t+1] = LoadActor("Judgments")
t[#t+1] = LoadActor("PercentScore")
t[#t+1] = LoadActor("ScoreVocalization")
t[#t+1] = LoadActor("StepsDisplayFrame")
t[#t+1] = LoadActor("storage");

for pn in ivalues(Players) do
	t[#t+1] = LoadActor("Grade",pn)
	t[#t+1] = CommonNormal()..{
		Name = "PlayerOptions";
		Text = string.upper(GAMESTATE:GetPlayerState(pn):GetPlayerOptionsString(0));
		InitCommand=function(self)
			if pn == PLAYER_1 then self:x(Left()+4):halign(0) else self:x(Right()-4):halign(1) end
			self:y(Bottom()-44):valign(1):maxwidth(896):zoom(0.4)
		end;
	};
end

local function GetCurrentPercentScore(pn)
	local pss = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats(pn)
	return 1 - pss:GetPercentDancePoints()
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		CommonNormal()..{
			Text="LOST SCORE: (-"..FormatPercentScore(GetCurrentPercentScore(pn)):gsub("%%","")..") NEXT GRADE: ("..NextStringGrade(pn)..")";
			InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+4):halign(0) else self:x(Right()-4):halign(1) end self:y(Bottom()-112):valign(1):zoom(0.4):shadowlength(1) end;
		};
	};
end

return t